      PROGRAM BAIN_STRAIN
      
      IMPLICIT NONE
      
      INTEGER RW
      PARAMETER(RW=97)
           
      DOUBLE PRECISION U(3),L(3),K,G,A,ROT(3,3)
      DOUBLE PRECISION DEFX,DEFZ,AUSL,FERL,BAIN(3,3)
      DOUBLE PRECISION DEF_L(3),DEF_U(3),INV_BAIN(3,3)
      DOUBLE PRECISION CROSS_NDEF(3),CROSS_DEF(3)
      DOUBLE PRECISION BEF_DEF(3,3),AFT_DEF(3,3),AFT_DEF_INV(3,3)
      DOUBLE PRECISION ROT_MAT(3,3),INV_LN_STRN(3,3),DET
      DOUBLE PRECISION INVERSE_ST(3,3),D(3),P(3),S,V,M,AL_J_GM(3,3)
      DOUBLE PRECISION LAT_INV_PL(3),LAT_INV_DI(3),CORRSP_MAT(3,3)
      DOUBLE PRECISION ALL_HABIT(24,3),ALL_DIRECTION(24,3)
      DOUBLE PRECISION SYMM_MATRIX(72,3),GM_J_AL(3,3),ALL_GM_J_AL(72,3)
      DOUBLE PRECISION ALL_AL_J_GM(72,3)
      INTEGER I
      
      CALL READING(AUSL,FERL,LAT_INV_PL,LAT_INV_DI,DEFX,DEFZ,BAIN,
&          SYMM_MATRIX,CORRSP_MAT)
           
      CALL CALCULATE_INV_LINE(U,DEFX,DEFZ)
            
      CALL CALCULATE_INV_NORMAL(L,DEFX,DEFZ)
            
      WRITE(*,*) 'ILS=',U(1),U(2),U(3)
      WRITE(*,*) 'ILN=',L(1),L(2),L(3) 

      CALL CALCULATE_INVERSE(BAIN,INV_BAIN)
      
      CALL MAT_MUL_ONE(DEF_U,BAIN,U)
      CALL MAT_MUL_TWO(DEF_L,L,INV_BAIN)
      
      WRITE(*,*) 'DEF_U=',DEF_U(1),DEF_U(2),DEF_U(3)
      WRITE(*,*) 'DEF_L=',DEF_L(1),DEF_L(2),DEF_L(3)
      
      CALL CROSS_PROD(U,L,CROSS_NDEF)
      CALL CROSS_PROD(DEF_U,DEF_L,CROSS_DEF)
      
C      WRITE(*,*) 'CROSS_NDEF=',CROSS_NDEF(1),CROSS_NDEF(2),CROSS_NDEF(3)
C      WRITE(*,*) 'CROSS_DEF=',CROSS_DEF(1),CROSS_DEF(2),CROSS_DEF(3)
      
      DO 10 I=1,3
         BEF_DEF(I,1)=U(I)
         AFT_DEF(I,1)=DEF_U(I)
         
         BEF_DEF(I,2)=L(I)
         AFT_DEF(I,2)=DEF_L(I)
         
         BEF_DEF(I,3)=CROSS_NDEF(I)
         AFT_DEF(I,3)=CROSS_DEF(I)
10    CONTINUE

    
      CALL CALCULATE_INVERSE(AFT_DEF,AFT_DEF_INV)

      CALL MAT_MUL(ROT_MAT,BEF_DEF,AFT_DEF_INV)
      
      CALL MAT_MUL(INV_LN_STRN,ROT_MAT,BAIN)
          
      CALL GET_DETER(INV_LN_STRN,DET)
      
      WRITE(*,*) 'DETERMINANT=',DET
      
      CALL CALCULATE_INVERSE(INV_LN_STRN,INVERSE_ST)
      
      CALL CALCULATE_HABIT(P,LAT_INV_PL,INVERSE_ST)
      
      CALL CALCULATE_DIRECTION(D,INV_LN_STRN,LAT_INV_DI,S,M,V,P)
      
      CALL CALCULATE_RELATION(CORRSP_MAT,INVERSE_ST,GM_J_AL)
      
      WRITE(*,*) 'P=',P(1),P(2),P(3)
      
      WRITE(*,*) 'D=',D(1),D(2),D(3)
      
      WRITE(*,*) 'VOL STRAIN=',V,' SHEAR STRAIN=',S,
&      ' TOTAL STRAIN',M
      
      CALL CALCULATE_ALL_HABIT_DIREC(ALL_HABIT,ALL_DIRECTION,
&          SYMM_MATRIX,P,D)

      OPEN(RW,FILE='sh-vol.txt',STATUS='OLD')
      
      WRITE(RW,*) M,S,V
      
      CLOSE(RW)
      
      CALL CALCULATE_INVERSE(GM_J_AL,AL_J_GM)
      CALL CALCULATE_ALL_GM_J_AL(ALL_GM_J_AL,SYMM_MATRIX,GM_J_AL)
      CALL CALCULATE_ALL_AL_J_AL(ALL_AL_J_GM,ALL_GM_J_AL)
    
      END
    
    
C ********************************* READING ************************************

      SUBROUTINE READING(AUSL,FERL,LAT_INV_PL,LAT_INV_DI,DEFX,DEFZ,BAIN,
&                SYMM_MATRIX,CORRSP_MAT)
      
      INTEGER RS
      PARAMETER (RS=81)
      
      DOUBLE PRECISION AUSL,FERL,LAT_INV_PL(3),LAT_INV_DI(3),DEFX,DEFZ
      DOUBLE PRECISION BAIN(3,3),SYMM_MATRIX(72,3),CORRSP_MAT(3,3)
      
      WRITE(*,*) 'PUT THE AUSTENITE LATTICE PARAMETER:'
      READ(*,*) AUSL
      WRITE(*,*) 'PUT THE FERRITE LATTICE PARAMETER:'
      READ(*,*) FERL
      
c      AUSL=3.619572
c      FERL=2.882

      CORRSP_MAT(1,1)=1
      CORRSP_MAT(1,2)=-1
      CORRSP_MAT(1,3)=0
      
      CORRSP_MAT(2,1)=1
      CORRSP_MAT(2,2)=1
      CORRSP_MAT(2,3)=0
      
      CORRSP_MAT(3,1)=0
      CORRSP_MAT(3,2)=0
      CORRSP_MAT(3,3)=1
      
      
      LAT_INV_PL(1)=0.707107
      LAT_INV_PL(2)=0.0
      LAT_INV_PL(3)=0.707107
      
      LAT_INV_DI(1)=0.707107
      LAT_INV_DI(2)=0.0
      LAT_INV_DI(3)=-0.707107
      

      DEFX=SQRT(2.0)*FERL/AUSL
      DEFZ=FERL/AUSL

C      DEFX=1.1201
C      DEFZ=0.8276
      
c      DEFX=1.136071
c      DEFZ=0.803324
      
      WRITE(*,*) 'DEFX = ',DEFX, 'DEFZ = ',DEFZ
      
      DO 10 I=1,3
         DO 20 J=1,3
            BAIN(I,J)=0
20       CONTINUE
10    CONTINUE

      BAIN(1,1)=DEFX
      BAIN(2,2)=DEFX
      BAIN(3,3)=DEFZ
      
      OPEN(RS,FILE='symm-mat.txt',STATUS='OLD')
      
      DO 30 I=1,72
         READ(RS,*) SYMM_MATRIX(I,1),SYMM_MATRIX(I,2),SYMM_MATRIX(I,3)
30    CONTINUE

      CLOSE(RS)
      
      RETURN
      
      END
      
C ***************************** END READING ************************************
      
C ******************** This subroutine calculates the inverse of a matrix ******

      SUBROUTINE CALCULATE_INVERSE(TATA,MAT_INV)   
      
      INTEGER I,J
      DOUBLE PRECISION DET,TATA(3,3)
      DOUBLE PRECISION MAT_INV(3,3)
      
      DET=TATA(1,1)*(TATA(2,2)*TATA(3,3)-TATA(2,3)*TATA(3,2))
&         -TATA(1,2)*(TATA(2,1)*TATA(3,3)-TATA(2,3)*TATA(3,1))
&         +TATA(1,3)*(TATA(2,1)*TATA(3,2)-TATA(2,2)*TATA(3,1))

      DO 10 I=1,3
         DO 20 J=1,3
            MAT_INV(I,J)=0
   20    CONTINUE
   10 CONTINUE

      MAT_INV(1,1)=(TATA(2,2)*TATA(3,3)-TATA(2,3)*TATA(3,2))/DET
      MAT_INV(1,2)=(TATA(3,2)*TATA(1,3)-TATA(3,3)*TATA(1,2))/DET
      MAT_INV(1,3)=(TATA(1,2)*TATA(2,3)-TATA(1,3)*TATA(2,2))/DET
      
      MAT_INV(2,1)=(TATA(2,3)*TATA(3,1)-TATA(2,1)*TATA(3,3))/DET
      MAT_INV(2,2)=(TATA(3,3)*TATA(1,1)-TATA(3,1)*TATA(1,3))/DET
      MAT_INV(2,3)=(TATA(1,3)*TATA(2,1)-TATA(1,1)*TATA(2,3))/DET
      
      MAT_INV(3,1)=(TATA(2,1)*TATA(3,2)-TATA(2,2)*TATA(3,1))/DET
      MAT_INV(3,2)=(TATA(3,1)*TATA(1,2)-TATA(3,2)*TATA(1,1))/DET
      MAT_INV(3,3)=(TATA(1,1)*TATA(2,2)-TATA(1,2)*TATA(2,1))/DET
      
      RETURN
      
      END
      
C ******************************End Subroutine *********************************

C ******************** This subroutine MULTIPLY a 3X3 matrix with a 3X1 matrix ******

      SUBROUTINE MAT_MUL_ONE(A,B,C)   
      
      INTEGER I,J
      DOUBLE PRECISION A(3),B(3,3),C(3)
      
      DO 10 I=1,3
         A(I)=0
10    CONTINUE

      DO 20 I=1,3
         DO 30 J=1,3
            A(I)=A(I)+B(I,J)*C(J)
30       CONTINUE
20    CONTINUE
      
      RETURN
      
      END
      
C ******************************End Subroutine ********************************* 

C ******************** This subroutine MULTIPLY a 3X1 matrix with a 3X3 matrix ******

      SUBROUTINE MAT_MUL_TWO(A,B,C)   
      
      INTEGER I,J
      DOUBLE PRECISION A(3),B(3),C(3,3)
      
      DO 10 I=1,3
         A(I)=0
10    CONTINUE

      DO 20 I=1,3
         DO 30 J=1,3
            A(I)=A(I)+B(J)*C(J,I)
30       CONTINUE
20    CONTINUE
      
      RETURN
      
      END
      
C ******************************End Subroutine ********************************* 

C **********************  CALCULATE CROSS PRODUCT *************************** C 

      SUBROUTINE CROSS_PROD(X,Y,Z)
      
      DOUBLE PRECISION X(3),Y(3),Z(3),TEMP
      INTEGER I
      
      Z(1) = X(2)*Y(3) - X(3)*Y(2)
      Z(2) = -1 * (X(1)*Y(3) - X(3)*Y(1))
      Z(3) = X(1)*Y(2) - X(2)*Y(1)
      
      TEMP = SQRT(Z(1)**2 + Z(2)**2 + Z(3)**2)
      
      Z(1)=Z(1)/TEMP
      Z(2)=Z(2)/TEMP
      Z(3)=Z(3)/TEMP
     
C      WRITE(*,*) 'THE VALUE OF K ARE', K(1), K(2), K(3)
      
      END

C ********************************************************************************** C

C ******* To evaluate the product A  of two 3x3 matrices B and C ******************** C

      SUBROUTINE MAT_MUL(A,B,C)
      DOUBLE PRECISION A(3,3),B(3,3),C(3,3)
      INTEGER I,J,K
      
      
      DO 1 I=1,3
         DO 2 J=1,3
            A(I,J)=0
2         CONTINUE
1     CONTINUE

      DO 10 I=1,3
         DO 20 J=1,3
            DO 30 K=1,3
               A(J,I)=A(J,I)+B(J,K)*C(K,I)
   30       CONTINUE
   20    CONTINUE
   10 CONTINUE
   
c      WRITE(*,*) 'NEW_MAT'
      
   
C
      RETURN
      END
C ******************************************************************************* 

C ******************** This subroutine calculates DETERMINANT of a matrix ******

      SUBROUTINE GET_DETER(TATA,DET)   
      
      DOUBLE PRECISION DET,TATA(3,3)
      
      
      DET=TATA(1,1)*(TATA(2,2)*TATA(3,3)-TATA(2,3)*TATA(3,2))
&         -TATA(1,2)*(TATA(2,1)*TATA(3,3)-TATA(2,3)*TATA(3,1))
&         +TATA(1,3)*(TATA(2,1)*TATA(3,2)-TATA(2,2)*TATA(3,1))

      RETURN
      
      END
      
C *******************************************************************************

C ******************** This subroutine calculates DETERMINANT of a matrix ******

      SUBROUTINE NORMALISE(P)   
      
      DOUBLE PRECISION P(3),A
      INTEGER I
      
      A=SQRT(P(1)**2+P(2)**2+P(3)**2)
      
      DO 10 I=1,3
         P(I)=P(I)/A
10    CONTINUE

      RETURN
      
      END
      
C *********************** CALCULATE INVARIANT LINE ********************************

      SUBROUTINE CALCULATE_INV_LINE(U,DEFX,DEFZ)
      
      DOUBLE PRECISION U(3),DEFX,DEFZ,K,G
      
      K=DEFX*DEFX-1
      G=DEFZ*DEFZ-1
      
      U(1)=SQRT(-K/(K+G))
      U(2)=1
      U(3)=-SQRT(-K/(K+G))
      
      CALL NORMALISE(U)
      
      RETURN
      
      END
      
C  ******************************************************************************

C ******************** CALCULATE INVARIANT NORMAL **********************************

      SUBROUTINE CALCULATE_INV_NORMAL(L,DEFX,DEFZ)
      
      DOUBLE PRECISION L(3),DEFX,DEFZ,K,G
      
      K=1-(1/DEFX**2)
      G=1-(1/DEFZ**2)
      
      L(1)=SQRT(-K/(K+G))
      L(2)=1
      L(3)=SQRT(-K/(K+G))
           
      CALL NORMALISE(L)
      
      RETURN
      
      END
      
C  ********************** CALCULATION OF HABIT PLANE **************************

      SUBROUTINE CALCULATE_HABIT(P,LAT_INV_PL,INVERSE_ST)
      
      DOUBLE PRECISION P(3),LAT_INV_PL(3),INVERSE_ST(3,3)
      INTEGER I
      
      CALL MAT_MUL_TWO(P,LAT_INV_PL,INVERSE_ST)
      
      DO 10 I=1,3
         P(I)=LAT_INV_PL(I)-P(I)
10    CONTINUE
      
      CALL NORMALISE(P)
      
      WRITE(*,*) 'PPPPP=',P(1),P(2),P(3)
      
      RETURN
      
      END
C  ********************* END CALCULATION OF HABIT PLANE *************************

C  ********************** CALCULATION OF SHEAR DIRECTION ************************

      SUBROUTINE CALCULATE_DIRECTION(D,INV_LN_STRN,LAT_INV_DI,S,M,V,P)
      
      DOUBLE PRECISION INV_LN_STRN(3,3),LAT_INV_DI(3),D(3),S,V,P(3)
      DOUBLE PRECISION C,M
      INTEGER I
      
      CALL MAT_MUL_ONE(D,INV_LN_STRN,LAT_INV_DI)
      
      DO 10 I=1,3
         D(I)=D(I)-LAT_INV_DI(I)
10    CONTINUE
      
      C=P(1)*LAT_INV_DI(1)+P(2)*LAT_INV_DI(2)+P(3)*LAT_INV_DI(3)
      
       DO 20 I=1,3
         D(I)=D(I)/C
20    CONTINUE

      M=SQRT(D(1)**2+D(2)**2+D(3)**2)
      
C      WRITE(*,*) 'M=',M
      DO 30 I=1,3
         D(I)=D(I)/M
30    CONTINUE
      
      V=0
      
      DO 40 I=1,3
         V=V+D(I)*P(I)
40    CONTINUE
      
      V=V*M
      
      S=SQRT(M**2-V**2)
      
      RETURN
      
      END
      
C ******************************** END CALCULATION OF SHEAR DIRECTION ************ 

C ** ***** Calculating habit plane and displacement direction for 24 variants **** 
 
      SUBROUTINE CALCULATE_ALL_HABIT_DIREC(ALL_HABIT,ALL_DIRECTION,
&                SYMM_MAT,FIRST_HABIT,FIRST_DIS)
      
      INTEGER RW,RWW
      
      PARAMETER(RW=98,RWW=99)
      
      DOUBLE PRECISION ALL_HABIT(24,3),SYMM_MAT(72,3),FIRST_HABIT(3)
      DOUBLE PRECISION ALL_DIRECTION(24,3),FIRST_DIS(3)
      INTEGER I,J,M,L,K
      
      DO 77 I=1,24
         DO 88 J=1,3
            ALL_HABIT(I,J)=0
            ALL_DIRECTION(I,J)=0
88       CONTINUE
77    CONTINUE

     
      DO 10 J=1,24
         M=1+(J-1)*3
         DO 20 K=1,3
            DO 30 L=1,3
               ALL_HABIT(J,K)=ALL_HABIT(J,K)+SYMM_MAT(M+K-1,L)
&               *FIRST_HABIT(L)
               ALL_DIRECTION(J,K)=ALL_DIRECTION(J,K)+SYMM_MAT(M+K-1,L)
&               *FIRST_DIS(L)
   30       CONTINUE
   20    CONTINUE            
   10 CONTINUE
       
      
      OPEN(RW,FILE='habit-other.txt',STATUS='OLD')
      
      DO 60 I=1,24
         WRITE(RW,*) ALL_HABIT(I,1),ALL_HABIT(I,2),ALL_HABIT(I,3)
60    CONTINUE
   
      CLOSE(RW)
      
      OPEN(RWW,FILE='dis-direction-other.txt',STATUS='OLD')
      
      DO 90 I=1,24
         WRITE(RWW,*) ALL_DIRECTION(I,1),ALL_DIRECTION(I,2),
&         ALL_DIRECTION(I,3)
90    CONTINUE
   
      CLOSE(RWW)
     
      END
      
C ** ***** END calculating habit plane and displacement direction for 24 variants **** 

C ** ******************* Calculating orientation relationship matrix ******************

      SUBROUTINE CALCULATE_RELATION(CORRSP_MAT,INVERSE_ST,GM_J_AL)
      
      DOUBLE PRECISION CORRSP_MAT(3,3),INVERSE_ST(3,3),GM_J_AL(3,3)
      DOUBLE PRECISION AL_J_GM(3,3)
      
      CALL MAT_MUL(AL_J_GM,CORRSP_MAT,INVERSE_ST)
            
      CALL CALCULATE_INVERSE(AL_J_GM,GM_J_AL)
           
      RETURN
      
      END
      
C ****************** END alculating orientation relationship matrix ****************  

C *************** Calculation of 24 orientation relationship matrix ****************

      SUBROUTINE CALCULATE_ALL_GM_J_AL(ALL_GM_J_AL,SYMM_MATRIX,GM_J_AL)
      
      INTEGER RWW,RW,DMAX
      PARAMETER(RW=99,RWW=98,DMAX=72)
      
      DOUBLE PRECISION GM_J_AL(3,3),ALL_GM_J_AL(72,3),SYMM_MATRIX(72,3)
      INTEGER J,K,L,N,S,I,WH
      
       DO 70 I=1,DMAX
         DO 80 J=1,3
            ALL_GM_J_AL(I,J)=0
   80    CONTINUE
   70 CONTINUE
   
      I=1
      DO 10 WHILE(I .LE. DMAX)
         J=I   
         DO 20 K=1,3
            DO 30 J=J,J+2        
               DO 40 N=1,3             
                  ALL_GM_J_AL(J,K)=ALL_GM_J_AL(J,K) + 
&                  SYMM_MATRIX(J,N)*GM_J_AL(N,K)
   40          CONTINUE
   30       CONTINUE    
            J=I
   20    CONTINUE
         I=I+3
   10 CONTINUE
      
      
      OPEN(RW,FILE='gm-j-al-other.txt',STATUS='OLD')
      
      DO 60 I=1,DMAX
         WRITE(RW,*) ALL_GM_J_AL(I,1), ALL_GM_J_AL(I,2), 
&           ALL_GM_J_AL(I,3)
60    CONTINUE
   
      CLOSE(RW)
      
      DO 66 I=1,3
         WRITE(*,*) GM_J_AL(I,1), GM_J_AL(I,2), 
&         GM_J_AL(I,3)
66    CONTINUE
      
      RETURN
      
      END
      
C ***************END Calculation of 24 orientation relationship matrix **************** 

      SUBROUTINE CALCULATE_ALL_AL_J_AL(ALL_AL_J_GM,ALL_GM_J_AL)
      
      INTEGER RWW
      PARAMETER (RWW=98)
      
      DOUBLE PRECISION ALL_AL_J_GM(72,3),ALL_GM_J_AL(72,3)
      DOUBLE PRECISION TEMP(3,3),TEMP_INV(3,3)
      INTEGER I,J
      
      DO 10 I=1,72,3
         DO 20 J=1,3
            DO 30 K=1,3   
               TEMP(J,K)=ALL_GM_J_AL(I+J-1,K)
30          CONTINUE
20       CONTINUE
     
         CALL CALCULATE_INVERSE(TEMP,TEMP_INV)
         
         DO 40 J=1,3
            DO 50 K=1,3
               ALL_AL_J_GM(I+J-1,K)=TEMP_INV(J,K)
50          CONTINUE
40       CONTINUE

        
10    CONTINUE

      OPEN(RWW,FILE='al-j-gm-other.txt',STATUS='OLD')
      
      DO 60 I=1,72
         WRITE(RWW,*) ALL_AL_J_GM(I,1), ALL_AL_J_GM(I,2), 
&           ALL_AL_J_GM(I,3)
60    CONTINUE
   
      CLOSE(RWW)
      
      RETURN
      
      END
      
      
      
      
      
     
      
      